//-----------------------------------------------------------------------------
// Torque Game Engine 
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------

//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~~//

if (isObject(moveMap))
   moveMap.delete();
new ActionMap(moveMap);

exec("./selection.bind.cs");


// additional console functions that were requested
function disasters(%enable)
{
   slgEnableDisasterManager(%enable);
}

function tutorial(%enable)
{
   if ($PlayingGame == false)
   {
      error("Cannot change the tutorial mode-- currently not playing the game.");
      return;
   }
   
   if (%enable == true)
   {
      /*
      slgActivateTask("TutorialTasks");
      TaskModifier.strMarkVertex("TutorialTasks", "TutorialStart", $TSV_AVAIL);

      $ReloadExperience = true;
      loadMission("assets/data/missions/sandlot/firstplayable.mis", false);
      */
   }
   else
   {
      tsEnableCommand(QuitJobCmdData, true);
      tsEnableCommand(DemolishCmdData, true);
      tsEnableCommand(BuildCmdData, true);
      tsEnableCommand(AttackCmdData, true);
      SaloonButton.disabled = false;
      HotelButton.disabled = false;
      GeneralButton.disabled = false;
      GranaryButton.disabled = false;
      BankButton.disabled = false;
      WatertowerButton.disabled = false;
      WindmillButton.disabled = false;
      OuthouseButton.disabled = false;
      RanchButton.disabled = false;
      GazeboButton.disabled = false;
      SheriffsOfficeButton.disabled = false;
      TrainstationButton.disabled = false;
      TradingpostButton.disabled = false;
      LumbermillButton.disabled = false;
      ChurchButton.disabled = false;
      BarbershopButton.disabled = false;
      WatchtowerButton.disabled = false;
      BlacksmithButton.disabled = false;
      BridgeButton.disabled = false;
      TownhallButton.disabled = false;
      StatueButton.disabled = false;
      TownbellButton.disabled = false;
      FlowerpotButton.disabled = false;
      FountainButton.disabled = false;
      WelcomesignButton.disabled = false;
      SmokehouseButton.disabled = false;
      //RoadwayButton.disabled = false;
      
      sendSandboxLoad();
   }
}

function fps(%enable)
{
   if (%enable == true)
   {
      metrics("fps");
   }
   else
   {
      metrics("");
   }
}

// this function is called every time the window become active
function stopDelayStartGameMenu()
{
   $DelayStartGameMenu = false;
}

// this function waits until the game is at a state where it can
// be paused (if the window becomes active, the function quits;
// otherwise, the funtion will pause the game when it can)
function delayStartGameMenu()
{
   if ($DelayStartGameMenu == false)
   {
      return;
   }
   
   if ($PlayingGame == false)
   {
      $DelayStartGameMenu = false;
      return;
   }
   
   if ($MissionLoaded == false || $DoneLoading == false ||
      $LoadingGameFromFile == true)
   {
      schedule(50, 0, "delayStartGameMenu");
      return;
   }
   
   $DelayStartGameMenu = false;
   if (isWindowActive() == false)
   {
      startGameMenu(1);
   }
}

// this is used to unpause the game (game does not unpause if the
// game options menu is up)
function slgUnpauseGame()
{
   // if the game menu is loaded, do not unpause
   if ($GameMenuLoaded == true)
   {
      $LoadingGameFromFile = false;
      return;
   }
   
   // otherwise, unpause the game
   slgUnpause();
   $LoadingGameFromFile = false;
}

$GameMenuLoaded = false;
$CanCancelMenu = false;
$DelayStartGameMenu = false;
$DisableQuitScenario = false;
$DisableReloadScenario = false;
function startGameMenu(%val)
{
   // pausing occurs on down state
   if (%val == 0)
   {
      return;
   }
   
   // pausing is disabled in menu and before menu
   if ($PlayingGame == false)
   {
      return;
   }
   
   // pausing is disabled when mission is loading
   if ($MissionLoaded == false)
   {
      $DelayStartGameMenu = true;
      delayStartGameMenu();
      return;
   }
   
   // if we are saving a game, changing pause states should not work
   if ($DoneLoading == false)
   {
      return;
   }
   
   $DelayStartGameMenu = false;
   
   // check if this is an unpause (instead of a pause)
   if ($GameMenuLoaded == true)
   {
      // do not remove the game menu behind an exit screen
      if ($ExitInProgress == true)
      {
         return;
      }
      
      stopGameMenu();
      clearStatGui();
      return;
   }
   
   // enable/disable menu buttons based on the scenario and loading states
   %count = $ResourceStack.getStackCount();
   %isMainMap = $ResourceStack.getStackCount() == 0;
   if ($DisableReloadScenario == true) {
      ReloadScenarioButton.disabled = true;
      //ReloadScenarioGuiButton.disabled = true;
   }
   else ReloadScenarioButton.disabled = %isMainMap;
   if ($DisableQuitScenario == true) {
      QuitScenarioButton.disabled = true;
      //QuitScenarioGuiButton.disabled = true;
   }
   else QuitScenarioButton.disabled = %isMainMap;
   LoadButton.disabled = (!slgCanLoadGame());
   
   PopUpHud.Visible = false;
   $GameMenuLoaded = true;
   $CanCancelMenu = true;
   Canvas.pushDialog(GameMenuGui);
   slgStackPause();
   csClearTargetState();
   muteSoundFX(true);
}

function stopGameMenu()
{
   if ($GameMenuLoaded == false)
   {
      return;
   }
   
   if ($CanCancelMenu == false)
   {
      return;
   }
   
   $GameMenuLoaded = false;
   $CanCancelMenu = false;
   Canvas.popDialog(GameMenuGui);
   Canvas.popDialog(StatGui);
   Canvas.popDialog(ExperienceGui);
   Canvas.popDialog(QuestScreenGui);
   slgStackUnpause();
   slgRenderWorld(true);
   muteSoundFX(false);
}

//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~//
// MOVEMENT CONTROL

$movementSpeed = 0.6; //1; // m/s

function setSpeed(%speed)
{
  if (%speed)
    $movementSpeed = %speed;
}

// TURN LEFT
$turn_lf_1 = false;
$turn_lf_2 = false;

function turnleft()
{
  if ($turn_lf_1 || $turn_lf_2)
    $mvYawRightSpeed = $Pref::Input::KeyboardTurnSpeed;
  else
    $mvYawRightSpeed = 0;
}
//
function turnleft_1(%val)
{
  $turn_lf_1 = %val;
  turnleft();
}
//
function turnleft_2(%val)
{
  $turn_lf_2 = %val;
  turnleft();
}

// TURN RIGHT
$turn_rt_1 = false;
$turn_rt_2 = false;

function turnright()
{
  if ($turn_rt_1 || $turn_rt_2)
    $mvYawLeftSpeed = $Pref::Input::KeyboardTurnSpeed;
  else
    $mvYawLeftSpeed = 0;
}
function turnright_1(%val)
{
  $turn_rt_1 = %val;
  turnright();
}
//
function turnright_2(%val)
{
  $turn_rt_2 = %val;
  turnright();
}



//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~//
// MOUSE CONTROL

$mouseLButtonDown = false;
$mouseRButtonDown = false;
$mouseLRButtonsDown = false;
$mouseLRButtonsWasDown = false;

function testForMouseMoveForward()
{
  if ($mouseLRButtonsDown != $mouseLRButtonsWasDown)
  {
    $mouseLRButtonsWasDown = $mouseLRButtonsDown;
    if ($mouseLRButtonsDown)
    {
      ServerConnection.clearPreSelectedObj();
      moveforward_3(1);
    }
    else
    {
      moveforward_3(0);
    }
  }
}

function removeBuilding()
{
   if (PlayGui.HasObject())
   {
      csUpdateCursor($CSC_NONE);
      
      %oldObject = PlayGui.removeObject();
      %oldObject.clearHighlight();
      if (isObject(%oldObject.ring) == true)
      {
         %oldObject.ring.stopSelectron();
         %oldObject.ring = 0;
      }
      return %oldObject;
   }
   
   return 0;
}

$leftClickTimer = 0;

function mouseLeftButton(%val)
{
   if (csCmdOnLeftClick(%val) == false)
   {
     $mouseLButtonDown = %val;
     $mouseLRButtonsDown = ($mouseLButtonDown && $mouseRButtonDown);
     
     // if an object is attached to the cursor, do not process cursor selection
     if (PlayGui.hasObject() == true)
     {
       return;
     }

     // the left mouse button is being pressed
     if ($mouseLButtonDown && !$mouseLRButtonsDown)
     {
        // find out which object would be dragged if we were to drag it
        PlayGui.pointRollover($pointSelectionLength, $TypeMasks::CharacterObjectType);
        gSelection.updateGroupFromPt($DRAG_ID);
        
        // reference selection groups
        %dragged = gSelection.getSelectedGroup($DRAG_ID);
        %selected = gSelection.getSelectedGroup($SELECT_ID);
        
        // if an object is in the drag group, then it is possible that
        // a drag command will be executed (only perform a drag if
        // the shift button is not down)
        if (%dragged.getSize() > 0 && $SLControl::Shift == false)
        {
           $canDragCommand = true;
           
           // if the drag object is not in the selected group, then we
           // need to update the selection group, so the player knows
           // which object/s can be dragged
           for (%index = 0; %index < %dragged.getSize(); %index++)
           {
              if (%selected.contains(%dragged.getID(%index)) == false)
              {
                 performSelection(false);
                 break;
              }
           }
        }

        // if not objects are under the current mouse, deselect everything
        if (%dragged.getSize() == 0)
        {
           // remove any objects that have been selected
           gSelection.removeAllFromGroup($SELECT_ID);
           
            // update task buttons
            updateTaskBtns();

            // update the selected decals on the ground
            updateSelectedSelectrons();

            // Update selected objects with command system
            csUpdateSelection();
        }
        
        // mouse last position should be saved (this is for dragging
        // commands, area selection, and point selection)
        startSelection();
     }
     else if (!$mouseLRButtonsDown)
     {
        $updateMousePos = true;
        
        // perform the selection and if that could not be done, then
        // we are in a drag mode and need to process that drag command
        if (performSelection(true) == false)
        {
        }
        
        $selectionAreaMode = false;
        $selectionDragMode = false;
        $canDragCommand = false;
        
        csCmdDragEnd();
     }
   }
}

function mouseRightButton(%val)
{  
  if (%val)
  {
     csCmdOnRightClick();
  }
}

//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~//

//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~//

// Zoom and FOV functions

if($Pref::player::CurrentFOV $= "")
   $Pref::player::CurrentFOV = 45;

function setZoomFOV(%val)
{
   if(%val)
      toggleZoomFOV();
}
      
function toggleZoom( %val )
{
   if ( %val )
   {
      $ZoomOn = true;
      setFov( $Pref::player::CurrentFOV );
   }
   else
   {
      $ZoomOn = false;
      setFov( $Pref::player::DefaultFov );
   }
}

// Camera & View functions

function toggleFreeLook( %val )
{
   if ( %val )
      $mvFreeLook = true;
   else
      $mvFreeLook = false;
}

function toggleCamera(%val)
{
   if (%val)
   {
      commandToServer('ToggleCamera');
      if (ServerConnection.getSelectedObj() == ServerConnection.player)
        ServerConnection.clearSelectedObj();
   }
}

function stepTo(%val)
{
   if (%val)
     commandToServer('dollyThirdPersonCam', true);
}

function stepFro(%val)
{
   if (%val)
     commandToServer('dollyThirdPersonCam', false);
}

// Message HUD functions

function pageMessageHudUp( %val )
{
   if ( %val )
      pageUpMessageHud();
}

function pageMessageHudDown( %val )
{
   if ( %val )
      pageDownMessageHud();
}

function resizeMessageHud( %val )
{
   if ( %val )
      cycleMessageHudSize();
}

// Demo recording functions

function startRecordingDemo( %val )
{
   /*
   if ( %val )
      startDemoRecord();
      */
}

function stopRecordingDemo( %val )
{
   if ( %val )
      stopDemoRecord();
}

// Helper Functions

function dropCameraAtPlayer(%val)
{
   if (%val)
      commandToServer('dropCameraAtPlayer');
}

function dropPlayerAtCamera(%val)
{
   if (%val)
      commandToServer('DropPlayerAtCamera');
}

// Dubugging Functions

$MFDebugRenderMode = 0;
function cycleDebugRenderMode(%val)
{
   if (!%val)
      return;

   if (getBuildString() $= "Debug")
   {
      if($MFDebugRenderMode == 0)
      {
         // Outline mode, including fonts so no stats
         $MFDebugRenderMode = 1;
         GLEnableOutline(true);
      }
      else if ($MFDebugRenderMode == 1)
      {
         // Interior debug mode
         $MFDebugRenderMode = 2;
         GLEnableOutline(false);
         setInteriorRenderMode(7);
         showInterior();
      }
      else if ($MFDebugRenderMode == 2)
      {
         // Back to normal
         $MFDebugRenderMode = 0;
         setInteriorRenderMode(0);
         GLEnableOutline(false);
         show();
      }
   }
   else
   {
      echo("Debug render modes only available when running a Debug build.");
   }
}

// Misc.

function net_graph(%val)
{
   if (%val)
      NetGraph::toggleNetGraph();
}


// GAME CONTROLS

// MOVE CHECKS
$move_fwd_1 = false;
$move_fwd_2 = false;
$move_bkwd_1 = false;
$move_bkwd_2 = false;
$move_lf_1 = false;
$move_lf_2 = false;
$move_rt_1 = false;
$move_rt_2 = false;
$accum_yaw = 0;
$accum_pitch = 0;
$freeRotate = false;

function getSnapMode()
{
   if ($serverCamera)
   {
      %component = $serverCamera.getCameraCmp();
      if (%component)
      {
         return %component.getSnapRotation();
      }
   }
   
   return false;
}

function setSnapMode()
{
   if ($serverCamera)
   {
      %component = $serverCamera.getCameraCmp();
      if (%component)
      {
         %component.startSnapRotation();
      }
   }
}

function setFreeRotate(%val)
{
   $freeRotate = %val;
   if (%val)
   {
      // turn off minimap rendering updates (do not know when camera rotates)
      %component = GameCamera.getCameraCmp();
      if (%component)
      {
         %component.updateMinimap(false);
      }
      
      cursorOff();
      $mvForwardAction = 0;
      $mvBackwardAction = 0;
      $mvLeftAction = 0;
      $mvRightAction = 0;
   }
   else
   {
      setSnapMode();
      cursorOn();
   }
}

function getMouseAdjustAmount(%val)
{
  // based on a default camera fov of 90'
  return(%val * ($cameraFov / 90) * 0.001);
}

function yaw(%val)
{
   if (getSnapMode() == false)
   {
     %amt = getMouseAdjustAmount(%val);
     $mvYaw += %amt;
     $accum_yaw += %amt;
   }
}

function pitch(%val)
{
   if (getSnapMode() == false)
   {
     %amt = getMouseAdjustAmount(%val);
     $mvPitch += %amt;
     $accum_pitch += %amt;
   }
}

// MOVE FORWARD
function moveForward()
{
   if (getSnapMode() == false && $freeRotate == false)
   {
      if ($move_fwd_1 || $move_fwd_2 || $move_fwd_3)
         $mvForwardAction = $movementSpeed;
      else
         $mvForwardAction = 0;
   }
}
function moveForward1(%val)
{
  $move_fwd_1 = %val;
  moveForward();
}
function moveForward2(%val)
{
  $move_fwd_2 = %val;
  moveForward();
}

// MOVE BACKWARD
function moveBackward()
{
   if (getSnapMode() == false && $freeRotate == false)
   {
      if ($move_bkwd_1 || $move_bkwd_2)
         $mvBackwardAction = $movementSpeed;
      else
         $mvBackwardAction = 0;
   }
}
function moveBackward1(%val)
{
  $move_bkwd_1 = %val;
  moveBackward();
}
function moveBackward2(%val)
{
  $move_bkwd_2 = %val;
  moveBackward();
}

// MOVE LEFT
function moveLeft()
{
   if (getSnapMode() == false && $freeRotate == false)
   {
      if ($move_lf_1 || $move_lf_2)
         $mvLeftAction = $movementSpeed;
      else
         $mvLeftAction = 0;
   }
}
function moveLeft1(%val)
{
  $move_lf_1 = %val;
  moveleft();
}
function moveLeft2(%val)
{
  $move_lf_2 = %val;
  moveleft();
}

// MOVE RIGHT
function moveRight()
{
   if (getSnapMode() == false && $freeRotate == false)   
   {
      if ($move_rt_1 || $move_rt_2)
         $mvRightAction = $movementSpeed;
      else
         $mvRightAction = 0;
   }
}
function moveRight1(%val)
{
  $move_rt_1 = %val;
  moveright();
}
function moveRight2(%val)
{
  $move_rt_2 = %val;
  moveright();
}

function questTest(%requiredCount, %optionalCount)
{
   %description = "This is the description of the quest.  ";
   
   for (%required = 1; %required >= 0; %required--)
   {
      if (%required == 1)
      {
         %startCount = 0;
         %totalCount = %requiredCount;
      }
      else
      {
         %startCount = %totalCount;
         %totalCount += %optionalCount;
      }
      for (%quest = %startCount; %quest < %totalCount; %quest++)
      {
         // set up the quest
         %desc = "This is the description for the quest.  ";
         %descCount = getRandom(1, 5);
         for (%index = 0; %index < %descCount; %index++)
         {
            %desc = %desc @ %desc;
         }
         CreateQuest(%required, "Quest #" @ %quest, "Trigger #" @ %quest, %desc, "Reward #" @ %quest);
         
         // check if the quest should have tasks
         if (getRandom(0, 1) == 0)
         {
            continue;
         }
         
         // add tasks to the quest
         %taskCount = getRandom(1, 10);
         %complete = getRandom(0, 1);
         for (%index = 0; %index < %taskCount; %index++)
         {
            if (getRandom(0, 1) == 0 && %index != 0)
            {
               CreateQuestTask("Quest #" @ %quest, "", "Long Task Description #" @ %index);
            }
            else
            {
               CreateQuestTask("Quest #" @ %quest, "Brief #" @ %index, "Long Task Description #" @ %index);
            }
         }
         
         for (%index = 0; %index < %taskCount; %index++)
         {
            if (%complete == 1 || getRandom(0, 1) == 0)
            {
               CompleteQuestTask("Quest #" @ %quest, "Brief #" @ %index);
            }
         }
      }
   }
}

function alertFireTest(%val)
{
   if(%val) {
      alertAdd($ALERT_FIRE, 5, "Fire");
   }
}

function alertTornadoTest(%val)
{
   if(%val) {
      alertAdd($ALERT_TORNADO, 1, "Tornado");
   }
}

function alertPlagueTest(%val)
{
   if(%val) {
      alertAdd($ALERT_PLAGUE, 1, "Plague");
   }
}
function alertBanditTest(%val)
{
   if(%val) {
      alertAdd($ALERT_BANDIT, 1, "Bandit");
   }
}
function alertQuestTest(%val)
{
   if(%val) {
      alertAdd($ALERT_QUEST, 2, "Quest");
   }
}

function alertFireEndTest(%val)
{
   if(%val) {
      alertRemove($ALERT_FIRE, 5, "Fire over");
   }
}

function alertTornadoEndTest(%val)
{
   if(%val) {
      alertRemove($ALERT_TORNADO, 1);
   }
}

function alertPlagueEndTest(%val)
{
   if(%val) {
      alertRemove($ALERT_PLAGUE, 1);
   }
}
function alertBanditEndTest(%val)
{
   if(%val) {
      alertRemove($ALERT_BANDIT, 1);
   }
}
function alertQuestEndTest(%val)
{
   if(%val) {
      alertRemove($ALERT_QUEST, 1);
   }
}

function shortcutMoveHeroToSpawnPoint(%val)
{
   if(%val) {
      commandToServer('MoveHeroToSpawnPoint');
   }
}
//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~~//

// default tool controls
GlobalActionMap.bindCmd(keyboard, "alt enter", "", "toggleFullScreen();");
if ($TORQUE_SHIPPING == false)
{
   GlobalActionMap.bindCmd(keyboard, F1, "", "contextHelp();");
   GlobalActionMap.bind(keyboard, F9, cycleDebugRenderMode);
   GlobalActionMap.bind(keyboard, tilde, toggleConsole);
}

function clientCmdLoadGameActions()
{
   LoadGameActions();
}

$GameActionsLoaded = false;

function LoadGameActions()
{
   if ($GameActionsLoaded == true) return;
   $GameActionsLoaded = true;
   
   if ($TORQUE_SHIPPING == false)
   {
   }
   
   // game camera controls
   moveMap.bind(keyboard, space, setFreeRotate);
   moveMap.bind(mouse, button1, mouseRightButton);
   moveMap.bind(mouse, xaxis, yaw);
   moveMap.bind(mouse, button0, mouseLeftButton);
   
   // shortcut controls
   moveMap.bind(keyboard, escape, startGameMenu);
   moveMap.bind(keyboard, w, shortcutCameraForward1);
   moveMap.bind(keyboard, s, shortcutCameraBackward1);
   moveMap.bind(keyboard, a, shortcutCameraLeft1);
   moveMap.bind(keyboard, d, shortcutCameraRight1);
   moveMap.bind(keyboard, "ctrl f1", shortcutMoveHeroToSpawnPoint);
   moveMap.bind(keyboard, up, shortcutCameraForward2);
   moveMap.bind(keyboard, down, shortcutCameraBackward2);
   moveMap.bind(keyboard, left, shortcutCameraLeft2);
   moveMap.bind(keyboard, right, shortcutCameraRight2);
   moveMap.bindCmd(keyboard, f1, "shortcutLocateHero();", "");
   moveMap.bindCmd(keyboard, f2, "shortcutLocateCombatUnit();", "");
   moveMap.bindCmd(keyboard, f3, "shortcutLocateJoblessUnit();", "");
   moveMap.bindCmd(keyboard, f4, "shortcutLocateCivilian();", "");
   moveMap.bindCmd(keyboard, f5, "shortcutLocateBuilding();", "");
   moveMap.bindCmd(keyboard, f6, "shortcutToggleQuests();", "");
   moveMap.bindCmd(keyboard, r, "shortcutBuildingRotate();", "");
   moveMap.bindCmd(keyboard, b, "shortcutBuildCommand();", "");
   moveMap.bindCmd(keyboard, pageup, "zoomOut();", "");
   moveMap.bindCmd(keyboard, pagedown, "zoomIn();", "");
   moveMap.bindCmd(keyboard, minus, "zoomOut();", "");
   moveMap.bindCmd(keyboard, equals, "zoomIn();", "");
   moveMap.bindCmd(keyboard, numpadadd, "zoomIn();", "");
   moveMap.bindCmd(keyboard, numpadminus, "zoomOut();", "");
   moveMap.bind(keyboard, numpad8, shortcutCameraForward2);
   moveMap.bind(keyboard, numpad2, shortcutCameraBackward2);
   moveMap.bind(keyboard, numpad4, shortcutCameraLeft2);
   moveMap.bind(keyboard, numpad6, shortcutCameraRight2);
}

function clientCmdUnloadGameActions()
{
   UnloadGameActions();
}

function UnloadGameActions()
{
   if ($GameActionsLoaded == false) return;
   $GameActionsLoaded = false;
   
   if($TORQUE_SHIPPING == false)
   {
   }
   
   // game camera controls
   moveMap.unbind(keyboard, space);
   moveMap.unbind(mouse, button1);
   moveMap.unbind(mouse, xaxis);
   moveMap.unbind(mouse, button0);
   
   // shortcut controls
   moveMap.unbind(keyboard, escape);
   moveMap.unbind(keyboard, w);
   moveMap.unbind(keyboard, s);
   moveMap.unbind(keyboard, a);
   moveMap.unbind(keyboard, d);
   moveMap.unbind(keyboard, "ctrl f1");
   moveMap.unbind(keyboard, up);
   moveMap.unbind(keyboard, down);
   moveMap.unbind(keyboard, left);
   moveMap.unbind(keyboard, right);
   moveMap.unbind(keyboard, f1);
   moveMap.unbind(keyboard, f2);
   moveMap.unbind(keyboard, f3);
   moveMap.unbind(keyboard, f4);
   moveMap.unbind(keyboard, f5);
   moveMap.unbind(keyboard, f6);
   moveMap.unbind(keyboard, r);
   moveMap.unbind(keyboard, b);
   moveMap.unbind(keyboard, pageup);
   moveMap.unbind(keyboard, pagedown);
   moveMap.unbind(keyboard, minus);
   moveMap.unbind(keyboard, equals);
   moveMap.unbind(keyboard, numpadadd);
   moveMap.unbind(keyboard, numpadminus);
   moveMap.unbind(keyboard, numpad8);
   moveMap.unbind(keyboard, numpad2);
   moveMap.unbind(keyboard, numpad4);
   moveMap.unbind(keyboard, numpad6);
}

//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~//~~~~~~~~~~~~~~~~~~~~~//


